<?php
include("connection.php");
include("jwt.php");

function sendResponse($code, $msg = '', $payload = '')
{
    echo json_encode([
        'code' => $code,
        'msg' => $msg,
        'payload' => $payload
    ]);
}

if ($_SERVER['REQUEST_METHOD'] === 'GET') {






    // authintication
    header('Content-Type: application/json');

    $headers = getallheaders();
    $auth_header = $headers['Authorization'] ?? '';

    if (!$auth_header || !str_starts_with($auth_header, 'Bearer ')) {
        http_response_code(401);
        echo json_encode(['error' => 'Authorization header missing']);
        exit;
    }

    $token = str_replace('Bearer ', '', $auth_header);
    $validation = json_decode(is_jwt_valid($token), true);

    if ($validation['status'] !== 'Success') {
        http_response_code(403);
        echo json_encode(['error' => 'Invalid or expired token']);
        exit;
    }








    $query = "SELECT * FROM enquiries";

    // Check if 'today' param is set and true
    if (isset($_GET['today']) && $_GET['today'] === 'true') {
        $today = date('Y-m-d');
        $query .= " WHERE DATE(createdAt) = '$today'";
    }

    $result = mysqli_query($conn, $query);

    if ($result) {
        $formattedEnquiries = [];

        while ($row = mysqli_fetch_assoc($result)) {
            $formattedEnquiries[] = [
                'name' => $row['name'],
                'email' => $row['email'],
                'details' => [
                    ['label' => 'Phone No', 'value' => $row['phone']],
                    ['label' => 'Message', 'value' => $row['message']]
                ],
                'status' => $row['status']
            ];
        }

        sendResponse(200, 'success', $formattedEnquiries);
    } else {
        sendResponse(500, 'Database error: ' . mysqli_error($conn));
    }
} else {
    http_response_code(405);
    sendResponse(405, "Method Not Allowed");
}
