<?php
include("connection.php");
include("jwt.php");

function sendResponse($code, $msg = '', $payload = '')
{
    echo json_encode([
        'code' => $code,
        'msg' => $msg,
        'payload' => $payload
    ]);
}

if ($_SERVER['REQUEST_METHOD'] === 'GET') {




    // authintication
    header('Content-Type: application/json');

    $headers = getallheaders();
    $auth_header = $headers['Authorization'] ?? '';

    if (!$auth_header || !str_starts_with($auth_header, 'Bearer ')) {
        http_response_code(401);
        echo json_encode(['error' => 'Authorization header missing']);
        exit;
    }

    $token = str_replace('Bearer ', '', $auth_header);
    $validation = json_decode(is_jwt_valid($token), true);

    if ($validation['status'] !== 'Success') {
        http_response_code(403);
        echo json_encode(['error' => 'Invalid or expired token']);
        exit;
    }








    $query = "SELECT * FROM bookings";

    // Check if 'today' param is set and true
    if (isset($_GET['today']) && $_GET['today'] === 'true') {
        $today = date('Y-m-d');
        $query .= " WHERE DATE(createdAt) = '$today'";
    }

    $result = mysqli_query($conn, $query);

    if ($result) {
        $formattedBookings = [];

        while ($row = mysqli_fetch_assoc($result)) {
            $booking = [
                'name' => $row['name'],
                'stay' => $row['stay'] ?? 'Unknown Stay', // fallback
                'details' => [
                    ['label' => 'Check-in', 'value' => date('d M Y, h A', strtotime($row['checkIn']))],
                    ['label' => 'Check-out', 'value' => date('d M Y, h A', strtotime($row['checkOut']))],
                    ['label' => 'Guests', 'value' => $row['guests']],
                    ['label' => isset($row['roomType']) ? 'Room Type' : 'Tent Type', 'value' => $row['roomType'] ?? $row['tentType'] ?? 'Not specified'],
                    ['label' => 'Booking ID', 'value' => $row['bookingId']],
                ],
                'status' => $row['status']
            ];

            $formattedBookings[] = $booking;
        }

        sendResponse(200, 'success', $formattedBookings);
    } else {
        sendResponse(500, 'Database error: ' . mysqli_error($conn));
    }
} else {
    http_response_code(405);
    sendResponse(405, "Method Not Allowed");
}
