<?php
// Include necessary files
include("connection.php"); // For database connection
include("jwt.php");

// Logger function (optional)
function log_to_file($message) {
    $logFile = 'login_log.txt';
    $timestamp = date('Y-m-d H:i:s');
    file_put_contents($logFile, "[$timestamp] $message" . PHP_EOL, FILE_APPEND);
}

header('Content-Type: application/json'); // Ensure the response is JSON

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = $_POST['username'] ?? '';
    $password = $_POST['password'] ?? '';

    // Log the input (only username for security)
    log_to_file("Login attempt: " . $username);

    // Prepare and bind
    $stmt = $conn->prepare("SELECT * FROM users WHERE username = ?");
    if (!$stmt) {
        echo json_encode(['status' => 'error', 'message' => 'Database error']);
        exit;
    }

    $stmt->bind_param("s", $username);
    $stmt->execute();
    $result = $stmt->get_result();
    $user = $result->fetch_assoc();

    // Check if user exists and password matches
    if ($user && password_verify($password, $user['password'])) {
        $headers = ['alg' => 'HS256', 'typ' => 'JWT'];
        $payload = [
            'user_id' => $user['id'],
            'username' => $user['username'],
            'exp' => time() + 3600 // Token valid for 1 hour
        ];

        $jwt = generate_jwt($headers, $payload);
        echo json_encode(['status' => 'success', 'token' => $jwt]);
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Invalid credentials']);
    }

    $stmt->close();
}

$conn->close();
