<?php
include("connection.php");
include("jwt.php");

// Allow CORS
header("Access-Control-Allow-Origin: *"); // You can replace * with specific origin for security
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization");

// Handle preflight OPTIONS request
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

header('Content-Type: application/json');


function sendResponse($code, $msg = '', $payload = '')
{
    http_response_code($code);
    echo json_encode([
        'code' => $code,
        'msg' => $msg,
        'payload' => $payload
    ]);
}

if ($_SERVER['REQUEST_METHOD'] === 'GET') {

    // --- Authentication ---
    $headers = getallheaders();
    $auth_header = $headers['Authorization'] ?? '';

    if (!$auth_header || !str_starts_with($auth_header, 'Bearer ')) {
        sendResponse(401, 'Authorization header missing');
        exit;
    }

    $token = str_replace('Bearer ', '', $auth_header);
    $validation = json_decode(is_jwt_valid($token), true);

    if (!isset($validation['status']) || $validation['status'] !== 'Success') {
        sendResponse(403, 'Invalid or expired token');
        exit;
    }

    // --- Query ---
    $query = "SELECT * FROM bookings WHERE mark='0'";
    if (isset($_GET['today']) && $_GET['today'] === 'true') {
        $today = date('Y-m-d');
        $query .= " AND DATE(createdAt) = ?";
        $stmt = $conn->prepare($query);
        $stmt->bind_param("s", $today);
        $stmt->execute();
        $result = $stmt->get_result();
    } else {
        $result = $conn->query($query);
    }

    if ($result) {
        $formattedBookings = [];
        while ($row = $result->fetch_assoc()) {
            $booking = [
                'id' => $row['id'],
                'name' => $row['name'],
                'site' => $row['site'] ?? 'Unknown Site',
                'details' => [
                    ['label' => 'Check-in', 'value' => date('d M Y', strtotime    ($row['checkin']))],
                    ['label' => 'Check-out', 'value' => date('d M Y', strtotime    ($row['checkout']))],
                    ['label' => 'Guests', 'value' => $row['group_size']],
                    ['label' => 'Email', 'value' => $row['email']],
                    ['label' => 'Phone', 'value' => $row['phone_number']],
                    ['label' => 'Address', 'value' => $row['address']],
                    ['label' => 'Created', 'value' => date('d M Y, h:i A', strtotime    ($row['createdAt']))],
                ],
            ];
    
            $formattedBookings[] = $booking;
        }

        sendResponse(200, 'success', $formattedBookings);
    } else {
        sendResponse(500, 'Database error: ' . $conn->error);
    }
} else {
    sendResponse(405, "Method Not Allowed");
}
