<?php
// CORS headers — add these at the very top
header("Access-Control-Allow-Origin: *"); // You can restrict to a specific domain like "https://jamaicacamp.com"
header("Access-Control-Allow-Methods: POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization");
header("Content-Type: application/json");

// Handle preflight OPTIONS request
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

include("./connection.php");

function sendResponse($code, $msg = '', $payload = '')
{
    echo json_encode([
        'code' => $code,
        'msg' => $msg,
        'payload' => $payload
    ]);
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Assuming you're using application/json content type
    $input = json_decode(file_get_contents("php://input"), true);

    $name = $input['name'] ?? '';
    $email = $input['email'] ?? '';
    $phone = $input['phone'] ?? '';
    $address = $input['address'] ?? '';
    $site = $input['site'] ?? '';
    $groupSize = $input['groupSize'] ?? '';
    $checkin = $input['checkin'] ?? '';
    $checkout = $input['checkout'] ?? '';

    if (!$name || !$email || !$phone || !$address || !$site || !$groupSize || !$checkin || !$checkout) {
        sendResponse(400, 'Missing required fields');
        exit;
    }

    $stmt = $conn->prepare("INSERT INTO bookings (name, phone_number, address, site, group_size, checkin, checkout, email, createdAt) VALUES (?, ?, ?, ?, ?, ?, ?, ?, NOW())");
    $stmt->bind_param("ssssssss", $name, $phone, $address, $site, $groupSize, $checkin, $checkout, $email);

    if ($stmt->execute()) {
        sendResponse(200, 'Booking added successfully');
    } else {
        sendResponse(500, 'Database error: ' . $stmt->error);
    }

    $stmt->close();
} else {
    http_response_code(405);
    sendResponse(405, "Method Not Allowed");
}
